#Cuadro X.2
#Correlaciones bivariadas parciales.

########################################################
#Seccin modificable por el usuario
########################################################

#Lectura de la base de datos
datos<-read.csv2("Cuadro X.1.V.csv",header=T,encoding="latin1")

#Seleccin de variables de inters. 
varInteresX<-c("Edad.hembra")
varInteresY<-c("N.huevos")
#varInteresZ<-c("T.epoca.cria")
#varInteresZ<-c("Alimento")
#varInteresZ<-c("T.epoca.cria","Alimento")
varInteresZ<-NULL

#Nombre del archivo de salida
sink("Salida Cuadro X.2.txt")

#######################################################
#Seccin que realiza el procedimiento
#######################################################

#Paquetes necesarios. ggm tiene la funcin pcor.test, y Rcmdr la funcin partial.cor
require(ggm)
require(Rcmdr)

#Organizacin de los datos
valoresX<-unlist(datos[,varInteresX])
valoresY<-unlist(datos[,varInteresY])
varZ<-data.frame(datos[,varInteresZ])
names(varZ)<-varInteresZ
if(length(varZ)==0) datos2<-data.frame(varind=valoresX,vardep=valoresY)
if(length(varZ)!=0) datos2<-data.frame(varind=valoresX,vardep=valoresY,varZ)
attach(datos2)

#Clculo de los coeficientes de correlacin y valores de p
PearsonParcial<-partial.cor(datos2,method="pearson",use="complete.obs")
PearsonParcialValorp<-pcor.test(PearsonParcial,ncol(varZ),n=nrow(datos2))
KendallParcial<-partial.cor(datos2,method="kendall",use="complete.obs")
KendallParcialValorp<-pcor.test(KendallParcial,ncol(varZ),n=nrow(datos2))

"Coeficiente de Pearson"
PearsonParcial
PearsonParcialValorp
"Coeficiente de Kendall"
KendallParcial
KendallParcialValorp
sink()


#######################################################
#Seccin que muestra los resultados
#######################################################

#Grficas
plot(varind,vardep,pch=19)

detach(datos2)
